///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _DOACCEPT_CPP
#define _DOACCEPT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/HashKey.H"
#include "../../SharedSource/Common.H"

#include "../Source/Routines.H"
#include "../Source/HandShake.H"
#include "../Source/Command.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::DoAccept(void)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::DoAccept.\n");
    #endif

	if(FD_ISSET(sckcListenSocket, &ReadFDS))
	{
		int iClient = 0;
		int iLength = 0;
		SOCKET sckLocalSocket = 0;

		SOCKADDR_IN RemoteClientSocketAddress;

		iLength = sizeof(SOCKADDR);
		if((sckLocalSocket = accept(sckcListenSocket, (SOCKADDR*)&RemoteClientSocketAddress, &iLength)) == SOCKET_ERROR)
		{
			WriteSysLogEx("CSockSrvr::DoAccept : accept returned SOCKET_ERROR", EVENT_ERROR);
			return false;
		}

		if(sckLocalSocket == 0)
		{
            WriteSysLogEx("CSockSrvr::DoAccept : accept returned 0", EVENT_ERROR);
			return false;
		}

		if(icCurrentClients == icMaxClients)
		{
            WriteSysLogEx("CSockSrvr::DoAccept : Accept Failed. Too Many Clients.", EVENT_ERROR);

			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
			return false;
		}

		if((iClient = GetFreeSocketSlot()) == -1)
		{
            WriteSysLogEx("CSockSrvr::DoAccept : Accept Failed. Not Enough Resources.", EVENT_ERROR);

			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
			return false;
		}

		bcWasConnect[iClient] = false;

		if(!OnAcceptConnectClient(iClient))
        {
            WriteSysLogEx("CSockSrvr::DoAccept : Accept Failed. OnAcceptConnectClient returned false.", EVENT_ERROR);

			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
        }

		if(!Events.OnAccept(this, iClient))
		{
			WriteSysLogEx("CSockSrvr::DoAccept : Accept Failed. OnAccept returned false.", EVENT_ERROR);
			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
		}

		// inet_ntoa(RemoteClientSocketAddress.sin_addr) // IP Address
        // ntohs(RemoteClientSocketAddress.sin_port) // Port

        icClientID[iClient] = icNextClientID++;
		bcConnected[iClient] = true;
		bcDisconnect[iClient] = false;
		sckcSocket[iClient] = sckLocalSocket;

		icCurrentClients++;

        return Start_ClientThread(iClient);
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

